class Item_Armor extends Armor2;

function bool HandlePickupQuery( inventory Item )
{
	local inventory S;

	if ( item.class == class ) 
	{
		S = Pawn(Owner).FindInventoryType(class'Item_Armor');
		
		if (  S==None )
		{
			if ( Charge<Item.Charge )	
				Charge = Item.Charge;
		}
		else
			{
			S.Charge += Charge;
			if ( S.Charge > 500 )
				S.Charge = 500;
			}

		if ( PickupMessageClass == None )
			Pawn(Owner).ClientMessage(PickupMessage, 'Pickup');
		else
			Pawn(Owner).ReceiveLocalizedMessage( PickupMessageClass, 0, None, None, Self.Class );
		Item.PlaySound (PickupSound,,2.0);
		Item.SetReSpawn();
		return true;				
	}
	if ( Inventory == None )
		return false;

	return Inventory.HandlePickupQuery(Item);
}

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy, S;

	Copy = Super.SpawnCopy(Other);
	S = Other.FindInventoryType(class'Item_Armor');	
	if ( S != None )
		{
		S.Charge += Charge;
		if ( S.Charge > 500 )
				S.Charge = 500;
		}
	return Copy;
}

defaultproperties
{
     bDisplayableInv=True
     PickupMessage="You got some Armor!"
     ItemName="Armor Item"
     RespawnTime=0.000000
     PickupViewMesh=Mesh'HealthItem'
     Charge=50
     ArmorAbsorption=75
     bIsAnArmor=True
     AbsorptionPriority=7
     MaxDesireability=2.000000
     PickupSound=Sound'Botpack.Pickups.ArmorUT'
     Mesh=Mesh'HealthItem'
     AmbientGlow=64
     MultiSkins(0)=Texture'Item_Armor'
     CollisionRadius=16.00000
     CollisionHeight=16.00000
     bCollideWhenPlacing=True
     bRotatingPickup=True
     RotationRate=(Roll=32768)
     RotationRate=(Pitch=26000)
     RotationRate=(Yaw=19200)
     LightEffect=LE_Shock
     LightBrightness=64
     LightHue=170
     LightRadius=16
     LightSaturation=80
     LightType=LT_Steady
}
